Attribute VB_Name = "modRanks"
'-----------------------------------------------------
' MirageBot Rank Manager Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private RankPath As String
Public Ranking() As RankingStruct
Public Type RankingStruct
    RankName As String
    Alias As String
    Safe As Boolean
    Plugin As Integer
    UserGroup As Boolean
    Console As Boolean
    Commands() As String
    Inherits() As String
    Message As String
    Flagged As Boolean
    Manages() As String
    PatternMatch As Boolean
End Type

Public Function IsRank(Rank1 As String, Rank2 As RankingStruct) As Boolean
    IsRank = (LCase$(Rank1) = LCase$(Rank2.RankName) Or LCase$(Rank1) = LCase$(Rank2.Alias))
End Function

Private Function BoolYesNo(yn As String) As Boolean
    If UCase$(yn) = "Y" Then BoolYesNo = True Else BoolYesNo = False
End Function

Public Sub SaveRanks()
On Error GoTo hErr:
    RankPath = AppData & "Ranks.ini"
    Dim FF As Integer
    FF = FreeFile
    Open RankPath For Append As #FF
    Close #FF
    Open RankPath For Output As #FF
        Dim I As Integer, temp As String
        For I = 0 To UBound(Ranking)
            With Ranking(I)
            If LenB(.RankName) > 0 Then
                Print #FF, "[" & Ranking(I).RankName & "]"
                Print #FF, "Console      = " & YesNo(.Console)
                Print #FF, "Flagged      = " & YesNo(.Flagged)
                Print #FF, "PatternMatch = " & YesNo(.PatternMatch)
                Print #FF, "Plugin       = " & .Plugin
                Print #FF, "Safe         = " & YesNo(.Safe)
                Print #FF, "UserGroup    = " & YesNo(.UserGroup)
                temp = .Alias
                    If LenB(temp) > 0 Then Print #FF, "Alias        = " & temp
                temp = Join(.Inherits, "; ")
                    If LenB(temp) > 0 Then Print #FF, "Inherits     = " & temp
                temp = Join(.Manages, "; ")
                    If LenB(temp) > 0 Then Print #FF, "Manages      = " & temp
                temp = .Message
                    If LenB(temp) > 0 Then Print #FF, "Message      = " & temp
                Print #FF, ""
                
                If LenB(.Commands(0)) Then
                    Dim FF2 As Integer, CommPath As String
                    FF2 = FreeFile
                    CommPath = AppData & "\Commands\" & Ranking(I).RankName & ".ini"
                    Open CommPath For Append As #FF2
                    Close #FF2
                    Open CommPath For Output As #FF2
                        Print #FF2, Join(.Commands, vbNewLine)
                    Close #FF2
                End If
            End If
            End With
        Next
    Close #FF
    Exit Sub
hErr:
End Sub

Public Sub LoadRanks()
On Error GoTo hErr:
    RankPath = AppData & "Ranks.ini"
    ReDim Ranking(0)
    Dim TS As TextStream, Content As String, Section As String, Console As Boolean, Flagged As Boolean, Safe As Boolean, UserGroup As Boolean, PatternMatch As Boolean, _
        Inherits() As String, Commands() As String, Manages() As String, Alias As String, Message As String, Plugin As Integer, XY As Integer
    For XY = frmBotMenu.mnuRank.UBound To 1 Step -1
        Unload frmBotMenu.mnuRank(XY)
    Next
    frmBotMenu.mnuRank(0).Caption = vbNullString
    Dim FSO As New FileSystemObject
1   Set TS = FSO.OpenTextFile(RankPath, ForReading, True)
    Set FSO = Nothing
2   Do Until TS.AtEndOfStream Or Err
3       Content = TS.ReadLine()
4       If LenB(Content) <> 0 Then
5           If Left$(Content, 1) = "[" And Right$(Content, 1) = "]" Then
6               If LenB(Section) <> 0 Then
                    Dim K As Integer, CF As String, CL As String
                    CF = AppData & "\Commands\" & Section & ".ini"
                    K = FreeFile
                    ReDim Commands(0)
                    If FSO.FileExists(CF) Then
                        Open CF For Input As #K
                        Do Until EOF(K)
                        Line Input #K, CL
                            If LenB(CL) > 0 Then
                                If LenB(Commands(0)) Then ReDim Preserve Commands(UBound(Commands) + 1)
                                Commands(UBound(Commands)) = CL
                            End If
                        Loop
                        Close #K
                    End If
7                   addRanking Section, Alias, Commands, Inherits, Manages, UserGroup, Flagged, PatternMatch, Plugin, Safe, Console, Message
                    If UserGroup Then
                        If LenB(frmBotMenu.mnuRank(0).Caption) = 0 Then
                            frmBotMenu.mnuRank(0).Caption = Section
                        Else
                            Load frmBotMenu.mnuRank(frmBotMenu.mnuRank.Count)
                            frmBotMenu.mnuRank(frmBotMenu.mnuRank.UBound).Caption = Section
                        End If
                    End If
                End If
8               Section = Mid$(Content, 2, Len(Content) - 2)
                Console = False
                Flagged = False
                Plugin = 0
                PatternMatch = False
                Safe = True
                UserGroup = True
9               ReDim Commands(0), Inherits(0), Manages(0)
                Message = vbNullString
                Alias = vbNullString
            End If
            
            If LenB(Section) <> 0 Then
                If Left$(Content, 1) <> "/" Then
                    If InStrB(Content, "=") <> 0 Then
                        Dim Splt() As String
                        Splt() = Split(Content, "=", 2)
                        Select Case UCase$(Trim$(Splt(0)))
                        Case "ALIAS"
                            Alias = Trim$(Splt(1))
                        Case "MESSAGE"
                            Message = Trim$(Splt(1))
                        Case "USERGROUP"
                            UserGroup = BoolYesNo(Trim$(Splt(1)))
                        Case "CONSOLE"
                            Console = BoolYesNo(Trim$(Splt(1)))
                        Case "FLAGGED"
                            Flagged = BoolYesNo(Trim$(Splt(1)))
                        Case "PATTERNMATCH"
                            PatternMatch = BoolYesNo(Trim$(Splt(1)))
                        Case "PLUGIN"
                            Plugin = Val(Trim$(Splt(1)))
                        Case "SAFE"
                            Safe = BoolYesNo(Trim$(Splt(1)))
                        Case "INHERITS"
12                           Inherits = Split(Trim$(Splt(1)), "; ")
                        Case "MANAGES"
13                           Manages = Split(Trim$(Splt(1)), "; ")
                        End Select
                    End If
                End If
            End If
        End If
    Loop
    If LenB(Section) <> 0 Then
        CF = AppData & "\Commands\" & Section & ".ini"
        K = FreeFile
        ReDim Commands(0)
        If FSO.FileExists(CF) Then
            Open CF For Input As #K
            Do Until EOF(K)
            Line Input #K, CL
                If LenB(CL) > 0 Then
                    If LenB(Commands(0)) Then ReDim Preserve Commands(UBound(Commands) + 1)
                    Commands(UBound(Commands)) = CL
                End If
            Loop
            Close #K
        End If
14      addRanking Section, Alias, Commands, Inherits, Manages, UserGroup, Flagged, PatternMatch, Plugin, Safe, Console, Message
        If UserGroup Then
            If LenB(frmBotMenu.mnuRank(0).Caption) = 0 Then
                frmBotMenu.mnuRank(0).Caption = Section
            Else
                Load frmBotMenu.mnuRank(frmBotMenu.mnuRank.Count)
                frmBotMenu.mnuRank(frmBotMenu.mnuRank.UBound).Caption = Section
            End If
        End If
    End If
    TS.Close
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Ranking", "Load" & "." & Erl
End Sub

Public Function GetIDByRank(RankOrAlias As String) As Long
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If LCase$(Ranking(I).RankName) = LCase$(RankOrAlias) Or LCase$(Ranking(I).Alias) = LCase$(RankOrAlias) Then _
            GetIDByRank = I: Exit Function
    Next I
    GetIDByRank = -1
End Function

Public Function GetRankByID(id As Long) As RankingStruct
    If id > -1 And id < UBound(Ranking) + 1 Then
        GetRankByID = Ranking(id)
    End If
End Function

Public Sub addRanking(Rank As String, Alias As String, _
    Commands() As String, Inherits() As String, Manages() As String, UserGroup As Boolean, Flagged As Boolean, PatternMatch As Boolean, Plugin As Integer, _
    Safe As Boolean, Console As Boolean, Message As String)
    
    Dim Index As Integer
    If LenB(Ranking(0).RankName) = 0 Then
        Index = 0
    Else
        ReDim Preserve Ranking(UBound(Ranking) + 1)
        Index = UBound(Ranking)
    End If
    
    With Ranking(Index)
        .RankName = Rank
        .Alias = Alias
        .Console = Console
        .PatternMatch = PatternMatch
        .Plugin = Plugin
        .Safe = Safe
        .Flagged = Flagged
        .UserGroup = UserGroup
        .Message = Message
        If Not ArrayInit(Not Commands) Then
            ReDim .Commands(0)
        Else
            .Commands = Commands
        End If
        If Not ArrayInit(Not Inherits) Then
            ReDim .Inherits(0)
        Else
            .Inherits = Inherits
        End If
        If Not ArrayInit(Not Manages) Then
            ReDim .Manages(0)
        Else
            .Manages = Manages
        End If
    End With
End Sub

Public Function rankManaged(YourRank As RankingStruct, TheirRank As RankingStruct) As Boolean
    Dim I As Integer
    For I = 0 To UBound(YourRank.Manages)
        If IsRank(YourRank.Manages(I), TheirRank) Then
            rankManaged = True
            Exit Function
        End If
    Next I
End Function

Public Function getRanking(Rank As String) As RankingStruct
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If IsRank(Rank, Ranking(I)) Then
            getRanking = Ranking(I)
            Exit Function
        End If
    Next I
End Function

Public Function rankingIndex(Rank As String) As Integer
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If IsRank(Rank, Ranking(I)) Then
            rankingIndex = I
            Exit Function
        End If
    Next I
End Function

Public Function rankingExists(Rank As String) As Boolean
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If IsRank(Rank, Ranking(I)) Then
            rankingExists = True
            Exit Function
        End If
    Next I
End Function

Public Function rankingMessage(Rank As String) As String
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If IsRank(Rank, Ranking(I)) Then
            rankingMessage = Ranking(I).Message
            Exit Function
        End If
    Next I
End Function

Public Function commandDefined(ByVal Command As String) As Boolean
    Dim I As Integer
    Command = LCase$(Command)
    For I = 0 To UBound(Ranking)
        If LenB(Ranking(I).RankName) <> 0 Then
            Dim X As Integer
            For X = 0 To UBound(Ranking(I).Commands)
                If Command = LCase$(Ranking(I).Commands(X)) Then
                    commandDefined = True
                    Exit Function
                End If
            Next X
        End If
    Next I
End Function

Public Function pluginLevel(Rank As String) As Integer
    If Rank = "<Console>" Then pluginLevel = 3: Exit Function
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If LenB(Ranking(I).RankName) <> 0 Then
            If IsRank(Rank, Ranking(I)) Then
                pluginLevel = Ranking(I).Plugin
                Exit Function
            End If
        End If
    Next I
    pluginLevel = 0
End Function

Public Function commandRank(ByVal Command As String) As String
    Dim I As Integer, J As Integer
    Command = LCase$(Command)
    For I = 0 To UBound(Ranking)
        If LenB(Ranking(I).RankName) <> 0 Then
            For J = 0 To UBound(Ranking(I).Commands)
                If Command = LCase$(Ranking(I).Commands(J)) Then
                    commandRank = Ranking(I).RankName
                    Exit Function
                End If
            Next J
        End If
    Next I
    commandRank = "<Undefined>"
End Function

Public Function commandCapable(ByVal Command As String, Rank As String) As Boolean
    If Rank = "<Console>" Then commandCapable = True: Exit Function
    Dim I As Integer
    Command = LCase$(Command)
    For I = 0 To UBound(Ranking)
        If LenB(Ranking(I).RankName) <> 0 Then
            If IsRank(Rank, Ranking(I)) Then
                Dim X As Integer, y As Integer, Z As Integer
                For X = 0 To UBound(Ranking(I).Commands)
                    If Command = LCase$(Ranking(I).Commands(X)) Then
                        commandCapable = True
                        Exit Function
                    End If
                Next X
                For X = 0 To UBound(Ranking(I).Inherits)
                    For y = 0 To UBound(Ranking)
                        If IsRank(Ranking(I).Inherits(X), Ranking(y)) Then
                            For Z = 0 To UBound(Ranking(y).Commands)
                                If Command = LCase$(Ranking(y).Commands(Z)) Then
                                    commandCapable = True
                                    Exit Function
                                End If
                            Next Z
                        End If
                    Next y
                Next X
            End If
        End If
    Next I
End Function

Public Function consoleRank() As String
    Dim I As Integer
    For I = 0 To UBound(Ranking)
        If Ranking(I).Console Then
            consoleRank = Ranking(I).RankName
            Exit Function
        End If
    Next I
End Function

